<?php
session_start();
// Conexión a base de datos de MySQL con PHP
$conn = new mysqli("localhost", "yoveraes_userdb", "t7@s5FxYn1GB", "yoveraes_botica");
// Comprobando si hay un error de conexión.
if ($conn->connect_error) {
    echo 'Error de conexion ' . $conn->connect_error;
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Caja Diaria</title>
    <script src="/Botica/views/ventas/js/jquery.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css"
        integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
    <script language="javascript" src="/Botica/views/ventas/js/jquery-3.1.1.min.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script language="javascript"></script>
    <style>
        /* Estilos personalizados para el botón */
        .boton-personalizado {
            background-color: #4CAF50;
            /* Verde */
            border: none;
            color: white;
            padding: 15px 32px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 18px;
            margin: 4px 2px;
            cursor: pointer;
            border-radius: 12px;
        }

        .boton-personalizado:hover {
            background-color: #45a049;
            /* Verde más oscuro */
        }
    </style>
    <style>
        /* Estilos básicos */
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }

        .container {
            max-width: 1000px;
            margin: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: center;
        }

        button {
            padding: 5px 10px;
            color: #fff;
            background: #e74c3c;
            border: none;
            cursor: pointer;
        }

        button:hover {
            background: #c0392b;
        }
    </style>
    <style>
        /* Estilo para reducir la fuente */
        .tabla-pequena {
            font-size: 14px;
            /* Ajusta el tamaño de la fuente */
            border-collapse: collapse;
            width: 100%;
        }

        .tabla-pequena th,
        .tabla-pequena td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        .tabla-pequena th {
            background-color: #3e64d3;
            text-align: left;
        }
    </style>
    <script>
        // Función para sumar los valores de la columna de montos
        function sumarMontos() {
            let total = 0;
            let montos = document.querySelectorAll('.total'); // Seleccionamos todos los elementos con la clase 'monto'
            montos.forEach(function (element) {
                total += parseFloat(element.innerText) || 0;  // Sumamos el contenido de cada elemento
            });
            // Mostrar el total en el campo de texto con id "totalMonto"
            document.getElementById('totalMonto').value = total.toFixed(2);
        }
    </script>
</head>
<h2 class="subtitle"><i class="fas fa-clipboard-check"></i> &nbsp;Pedidos | Ventas Totales
</h2>

<body>
    <!--h2>Reporte de Pedidos Totales</!--h2-->
    <label style="font-size:18px;color:rgb(28,45,142);">Desde: <input style="cursor:pointer;" type="date"
            id="fecha_ini"></label>
    <label style="font-size:18px;color:rgb(28,45,142);">Hasta: <input style="cursor:pointer;" type="date"
            id="fecha_fin"></label>
    <input type="checkbox" id="filtrar_usuario" style="cursor:pointer;">
    <label for="filtrar_usuario" style="cursor:pointer; font-size:18px; color:rgb(28,45,142);"><b>Usuarios</b></label>
    <select id="usuario" disabled>
        <option value="">Todos</option>
        <?php
        $result = $conn->query("SELECT idusuario, correo FROM usuario");
        while ($row = $result->fetch_assoc()) {
            echo "<option value='{$row['correo']}'>{$row['correo']}</option>";
        }
        ?>
    </select>
    <button class="btn-primary  btn-sm" onclick="generarReporte()">Consultar</button>
    <button class="btn-success  btn-sm" onclick="exportarExcel()">Exportar a Excel</button>
    <button class="btn-danger  btn-sm" onclick="imprimirPDF()">Imprimir PDF</button>
    <table border="1" class="table table-striped table-hover tabla-pequena" style="width: 100%;">
        <thead class="table-dark table-bordered">
            <tr>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;">Item</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;">Fecha Pedido</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;">N° Documento</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;">Hora Pedido</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;">Cliente</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;">Direccion</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;">Total</th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;"></th>
                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;"></th>
            </tr>
        </thead>
        <tbody id="tabla_datos"></tbody>
    </table>
    <script>
        $(document).ready(function () {
            $('#filtrar_usuario').change(function () {
                $('#usuario').prop('disabled', !this.checked);
            });
        });
        function generarReporte() {
            let fecha_ini = $('#fecha_ini').val();
            let fecha_fin = $('#fecha_fin').val();
            let usuario = $('#filtrar_usuario').is(':checked') ? $('#usuario').val() : '';
            $.post('/Botica/views/ventas/cargar_ventaz.php', { fecha_ini, fecha_fin, usuario }, function (data) {
                $('#tabla_datos').html(data);
            });
        }
        function editarTotal(id) {
            let nuevo_total = prompt("Ingrese el nuevo total:");
            if (nuevo_total) {
                $.post('/Botica/views/ventas/editar_total.php', { id, nuevo_total }, function () {
                    generarReporte();
                });
            }
        }
        function exportarExcel() {
            window.location.href = '/Botica/views/ventas/exportar_excel.php?fecha_ini=' + $('#fecha_ini').val() + '&fecha_fin=' + $('#fecha_fin').val() + '&usuario=' + ($('#filtrar_usuario').is(':checked') ? $('#usuario').val() : '');
        }
        function imprimirPDF() {
            window.open('/Botica/views/ventas/imprimir_pdf.php?fecha_ini=' + $('#fecha_ini').val() + '&fecha_fin=' + $('#fecha_fin').val() + '&usuario=' + ($('#filtrar_usuario').is(':checked') ? $('#usuario').val() : ''), '_blank');
        }
    </script>
    <div class="form-container">
        <div class="card-body">
            <div class="row">
                <hr>
                <!--div class="col-md-7">
                    <label for="totalC" style="font-size:16px; color:rgb(25,54,93);height:10px;"><strong>Caja Diaria
                            Contado
                            (Hoy)</strong></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <input style="width: 80; font-size:16px; cursor:pointer;text-align: right;" type="text" id="totalC"
                        name="totalC" readonly>
                </!--div>
                <div class="col-md-7">
                    <label for="totalT" style="font-size:16px; color:rgb(25,54,93);height:10px;"><strong>Caja Diaria
                            Transferencia (Hoy)</strong></label>&nbsp;&nbsp;&nbsp;
                    <input style="width: 80; font-size:16px; cursor:pointer;text-align: right;" type="text" id="totalT"
                        name="totalT" readonly>
                </div>
                <div class="col-md-7">
                    <label for="totalY" style="font-size:16px; color:rgb(25,54,93);height:10px;"><strong>Caja Diaria
                            Yape
                            (Hoy)</strong></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <input style="width: 80; font-size:16px; cursor:pointer;text-align: right;" type="text" id="totalY"
                        name="totalY" readonly>
                </div>
                <div class="col-md-7">
                    <label for="totalP" style="font-size:16px; color:rgb(25,54,93);height:10px;"><strong>Caja Diaria
                            Plin
                            (Hoy)</strong></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <input style="width: 200; font-size:16px; cursor:pointer;text-align: right;" type="text" id="totalP"
                        name="totalP" readonly>
                </div>
                <div-- class="col-md-7">
                    <label for="totalO" style="font-size:16px; color:rgb(25,54,93);height:10px;"><strong>Caja Diaria
                            Otro
                            (Hoy)</strong></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <input style="width: 80; font-size:16px; cursor:pointer;text-align: right;" type="text" id="totalO"
                        name="totalO" readonly>
                </div-->
                <hr>
                <div class="col-md-6">
                    <div class="input-group mb-5">
                        <label for="total" style="font-size:22px; color:rgb(25,54,93);"><strong>Total
                                Monto(Pedidos)</strong></label>&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="far fa-money-bill-alt"></i></span>
                            <input style="width: 110px; font-size:22px; cursor:pointer;text-align: right;" type="text"
                                id="total" name="total" readonly>
                        </div>
                    </div>
                    <hr>
                </div>
            </div>
        </div>
    </div>
</body>

</html>